define([
    'backbone',
    'marionette',
    'modules/form/section-view',
    'json!modules/community-care-request/new-appointment-request-question/preferred-provider/choices/choice.json', // eslint-disable-line max-len
], function(
    Backbone,
    Marionette,
    SectionView,
    metadata
) {
    'use strict';
    return SectionView.extend({
        initialize: function(options) {
            var sectionName = 'additional-appointment-preferences';
            this.legend = this.getLegendFromMetadata(sectionName, metadata, false) || '';
            this.collection = this.getQuestionsFromMetadata(sectionName, metadata, options);
            this.model = options.model;
            this.initializeQuestionEventListeners();
            this.validator = options.validator;
        },
    });
});
